/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.loading.definition.geometry;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.class_243;
import net.minecraft.class_3518;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.util.JsonUtil;

@ApiStatus.Internal
public record GeometryDescription(String identifier, @Nullable Float visibleBoundsWidth, @Nullable Float visibleBoundsHeight, @Nullable class_243 visibleBoundsOffset, int textureWidth, int textureHeight) {
    public static JsonDeserializer<GeometryDescription> gsonDeserializer() throws JsonParseException {
        return (json, type, context) -> {
            JsonObject obj = json.getAsJsonObject();
            String identifier = class_3518.method_15253((JsonObject)obj, (String)"identifier", null);
            Float visibleBoundsWidth = JsonUtil.getOptionalFloat(obj, "visible_bounds_width");
            Float visibleBoundsHeight = JsonUtil.getOptionalFloat(obj, "visible_bounds_height");
            class_243 visibleBoundsOffset = JsonUtil.jsonToVec3((JsonElement)class_3518.method_15292((JsonObject)obj, (String)"visible_bounds_offset", null));
            int textureWidth = class_3518.method_15282((JsonObject)obj, (String)"texture_width", (int)16);
            int textureHeight = class_3518.method_15282((JsonObject)obj, (String)"texture_height", (int)16);
            if (!obj.has("texture_width") || !obj.has("texture_height")) {
                GeckoLibConstants.LOGGER.warn("GeckoLib model {} does not have texture dimensions specified, likely an invalid geometry json!", (Object)identifier);
            }
            return new GeometryDescription(identifier == null ? String.valueOf(obj.hashCode()) : identifier, visibleBoundsWidth, visibleBoundsHeight, visibleBoundsOffset, textureWidth, textureHeight);
        };
    }
}

